//Caption:To Design a Digital IIR Butterworth LPF Filter from Analog IIR 
//Butterworth Filter and LPF to BSF using Digital Transformation
clear all;
clc;
close;
omegaP = 0.2*%pi;   //Filter cutoff frequency
omegaL =  (1/5)*%pi;   //Lower Cutoff frequency for BSF              
omegaU =  (3/5)*%pi;   //Upper Cutoff frequency for BSF    
z=poly(0,'z');
H_LPF = (0.245)*(1+(z^-1))/(1-0.509*(z^-1))//Bilinear transformation
alpha = (cos((omegaU+omegaL)/2)/cos((omegaU-omegaL)/2)); //parameter 'alpha'
k = tan((omegaU - omegaL)/2)*tan(omegaP/2); //parameter 'k'
NUM =((z^2)-((2*alpha/(1+k))*z)+((1-k)/(1+k))); //Numerator
DEN = (1-((2*alpha/(1+k))*z)+(((1-k)/(1+k))*(z^2))); //Denominator
HZ_BSF=horner(H_LPF,NUM/DEN); //LPF to BSF conversion using digital transformation
HW  =frmag(HZ_BSF(2),HZ_BSF(3),512); //frequency response for 512 points
W = 0:%pi/511:%pi;
a=gca();
a.thickness = 1;
plot(W/%pi,HW,'r')
a.foreground = 1;
a.font_style = 9; 
xgrid(1)
xtitle('Magnitude Response of BSF Filter cutoff freq [0.2,0.6] ','Normalized Digital Frequency--->','Magnitude');